class DanesXmasPackage expands Mutator config;


#exec TEXTURE IMPORT NAME=Blue FILE=Textures\Blue.bmp
#exec TEXTURE IMPORT NAME=Red FILE=Textures\Red.bmp
#exec TEXTURE IMPORT NAME=Green FILE=Textures\Green.bmp
#exec TEXTURE IMPORT NAME=Gold FILE=Textures\Gold.bmp
#exec TEXTURE IMPORT NAME=Black FILE=Textures\Black.bmp
#exec TEXTURE IMPORT NAME=White FILE=Textures\White.bmp
#exec TEXTURE IMPORT NAME=Purple FILE=Textures\Purple.bmp
#exec TEXTURE IMPORT NAME=Brown FILE=Textures\Brown.bmp
#exec TEXTURE IMPORT NAME=Button FILE=Textures\Button.bmp
#exec TEXTURE IMPORT NAME=HatDeco FILE=Textures\Hatdeco.bmp
#exec TEXTURE IMPORT NAME=InvisDeco FILE=Textures\Invisdeco.bmp
#exec TEXTURE IMPORT NAME=DrumDeco1 FILE=Textures\Drumdeco1.bmp
#exec TEXTURE IMPORT NAME=DrumDeco2 FILE=Textures\Drumdeco2.bmp
#exec TEXTURE IMPORT NAME=SplashLogo1 FILE=Textures\SplashLogo1.bmp
#exec TEXTURE IMPORT NAME=SplashLogo2 FILE=Textures\SplashLogo2.bmp
#exec TEXTURE IMPORT NAME=SplashLogo3 FILE=Textures\SplashLogo3.bmp
#exec TEXTURE IMPORT NAME=SantaHome FILE=Textures\SantaHome.bmp
#exec TEXTURE IMPORT NAME=SantaCapt FILE=Textures\SantaCapt.bmp
#exec TEXTURE IMPORT NAME=SantaDown FILE=Textures\SantaDown.bmp

#exec AUDIO IMPORT FILE="Sounds\ComicIntro.WAV" NAME="ComicIntro"

var config bool bReplaceMedBox, bReplaceVial, bReplaceHealthPack, bReplaceArmor, bReplaceThighPads, bReplaceUDamage, bReplaceInvis, bReplaceBoots, bReplaceBelt;
var int VialCount, MedCount;
var config bool bCTFSnowSB, bDMSnowSB, bTDMSnowSB, bMHSnowSB, bDOMSnowSB, bASSnowSB, bLMSSnowSB, bJBSnowSB, bSGSnowSB, bUseSantaFlags;

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
  Super.CheckReplacement(Other, bSuperRelevant);

  if ((Other.IsA('XmasShieldBelt')) || (Other.IsA('XmasMedBoxBlue')) || (Other.IsA('XmasMedBoxRed')) || (Other.IsA('XmasMedBoxGreen')) || (Other.IsA('XmasMedBoxGold')) || (Other.IsA('XmasVialBlue')) || (Other.IsA('XmasVialRed')) || (Other.IsA('XmasVialGreen')) || (Other.IsA('XmasVialGold')) || (Other.IsA('XmasHealthPack')) || (Other.IsA('xmasThighPads')) || (Other.IsA('xmasUDamage')) || (Other.IsA('xmasInvisibility')) || (Other.IsA('xmasJumpboots')) || (Other.IsA('XmasArmor')))
	{
	return true;
	}


  if ((Other.IsA('HealthVial')) || (Other.IsA('Bandages')) || (Other.IsA('UTJHealthVial')) && ( bReplaceVial ))
	{
	if ( VialCount == 0 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasVialBlue");
		VialCount = 1;
		return false;
		}
	else if ( VialCount == 1 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasVialRed");
		VialCount = 2;
		return false;
		}
	else if ( VialCount == 2 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasVialGreen");
		VialCount = 3;
		return false;
		}
	else if ( VialCount == 3 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasVialGold");
		VialCount = 0;
		return false;
		}
	}

  if ((Other.IsA('HealthPack')) || (Other.IsA('SuperHealth')) || (Other.IsA('UTJHealthPack')) && ( bReplaceHealthPack ))
	{
	  ReplaceWith(Other,"DanesXmasV3.XmasHealthPack");
		return false;
	}

  if ((Other.IsA('MedBox')) || (Other.IsA('Health')) || (Other.IsA('UTJUnrealHealth')) || (Other.IsA('UTJNaliFruit')) || (Other.IsA('NaliFruit')) || (Other.IsA('UTJMedBox')) || (Other.IsA('UTJHealth')) && ( bReplaceMedBox ))
	{
	if ( MedCount == 0 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasMedBoxBlue");
		MedCount = 1;
		return false;
		}
	else if ( MedCount == 1 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasMedBoxRed");
		MedCount = 2;
		return false;
		}
	else if ( MedCount == 2 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasMedBoxGreen");
		MedCount = 3;
		return false;
		}
	else if ( MedCount == 3 )
		{
		ReplaceWith(Other,"DanesXmasV3.XmasMedBoxGold");
		MedCount = 0;
		return false;
		}
	}





  if ((Other.IsA('Armor2')) || (Other.IsA('Armor')) && ( bReplaceArmor ))
	{
	  ReplaceWith(Other,"DanesXmasV3.XmasArmor");
		return false;
	}


  if ((Other.IsA('ThighPads')) && ( bReplaceThighPads ))
	{
	  ReplaceWith(Other,"DanesXmasV3.xmasThighPads");
		return false;
	}


  if ((Other.IsA('UDamage')) || (Other.IsA('Amplifier')) && ( bReplaceUDamage ))
	{
	  ReplaceWith(Other,"DanesXmasV3.xmasUDamage");
		return false;
	}


  if ((Other.IsA('UT_Invisibility')) || (Other.IsA('Invisibility')) && ( bReplaceInvis ))
	{
	  ReplaceWith(Other,"DanesXmasV3.xmasInvisibility");
		return false;
	}

  if ((Other.IsA('UT_Jumpboots')) || (Other.IsA('JumpBoots')) && ( bReplaceBoots ))
	{
	  ReplaceWith(Other,"DanesXmasV3.xmasJumpboots");
		return false;
	}


  if ((Other.IsA('UT_ShieldBelt')) || (Other.IsA('ShieldBelt')) && ( bReplaceBelt ))
	{
	  ReplaceWith(Other,"DanesXmasV3.XmasShieldBelt");
		return false;
	}

	return true;
}


// CTF HUD

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	switch (Level.Game.Default.GameName)
		{
			case "Capture the Flag":
			if ( bUseSantaFlags )
				{
				Level.Game.HUDType = Class'DanesXmasV3.CTFHUD';
				}
			if ( bCTFSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowCTFSB';
				}
			break;
			case "Tournament DeathMatch":
			if ( bDMSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowDMSB';
				}
			break;
			case "Tournament Team Game":
			if ( bTDMSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowTDMSB';
				}
			break;
			case "Monster Hunt":
			if ( bMHSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowMHSB';
				}
			break;
			case "Domination":
			if ( bDOMSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowDOMSB';
				}
			break;
			case "Assault":
			if ( bASSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowASSB';
				}
			break;
			case "Last Man Standing":
			if ( bLMSSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowLMSSB';
				}
			break;
			case "Jailbreak":
			if ( bJBSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowJBSB';
				}
			break;
			case "nOs*Badger's SiegeXXL2g":
			if ( bSGSnowSB )
				{
				Level.Game.ScoreBoardType = Class'DanesXmasV3.SnowSGSB';
				Level.Game.GameName = "SiegeXXL2g Xmas Edition";
				}
			break;
			default:
			return;
		}
}

defaultproperties
{
     bReplaceMedBox=True
     bReplaceVial=True
     bReplaceHealthPack=True
     bReplaceArmor=True
     bReplaceThighPads=True
     bReplaceUDamage=True
     bReplaceInvis=True
     bReplaceBoots=True
     bReplaceBelt=True
     bCTFSnowSB=True
     bDMSnowSB=True
     bTDMSnowSB=True
     bMHSnowSB=True
     bUseSantaFlags=True
}
